<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>NextGen Sports Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-color: #0a0a0a;
            --sidebar-color: rgba(26, 26, 26, 0.8);
            --text-color: #ffffff;
            --accent-color: #00ddeb;
            --button-bg: linear-gradient(45deg, #00ddeb, #ff00ff, #ffffff);
            --button-hover-bg: linear-gradient(45deg, #33eeff, #ff33ff, #f0f0f0);
            --glass-bg: rgba(255, 255, 255, 0.1);
            --glass-border: 1px solid rgba(255, 255, 255, 0.2);
            --webview-bg: #1a1a1a;
            --glow: 0 0 15px rgba(0, 221, 235, 0.8), 0 0 30px rgba(255, 0, 255, 0.4);
            --shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
            --transition: all 0.3s ease;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: var(--bg-color);
            color: var(--text-color);
            display: flex;
            height: 100vh;
            overflow: hidden;
            overscroll-behavior: none;
        }

        .sidebar {
            width: 200px;
            background: var(--sidebar-color);
            backdrop-filter: blur(10px);
            padding: 20px 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: width 0.3s ease;
            position: relative;
        }

        .sidebar.collapsed {
            width: 60px;
        }

        .hamburger {
            display: none;
            font-size: 24px;
            background: none;
            border: none;
            color: var(--text-color);
            cursor: pointer;
            padding: 10px;
            tabindex: 0;
        }

        .logo {
            width: 50px;
            height: 50px;
            margin-bottom: 20px;
            transition: var(--transition);
        }

        .sidebar.collapsed .logo {
            width: 40px;
            height: 40px;
        }

        .button-container {
            width: 100%;
            padding: 5px;
        }

        .button {
            width: 100%;
            padding: 14px;
            border: none;
            border-radius: 12px;
            font-size: 15px;
            color: var(--text-color);
            background: var(--button-bg);
            background-size: 200% 100%;
            backdrop-filter: blur(10px);
            border: var(--glass-border);
            transition: var(--transition);
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 10px;
            position: relative;
            overflow: hidden;
            will-change: transform, box-shadow;
            animation: pulse 3s infinite ease-in-out;
            tabindex: 0;
        }

        @keyframes pulse {
            0%, 100% { box-shadow: var(--glow); }
            50% { box-shadow: 0 0 20px rgba(0, 221, 235, 1), 0 0 40px rgba(255, 0, 255, 0.6); }
        }

        .button:hover, .button:focus {
            background-position: 100% 0;
            background: var(--button-hover-bg);
            transform: scale(1.05);
            box-shadow: 0 0 25px rgba(0, 221, 235, 1), 0 0 50px rgba(255, 0, 255, 0.6);
            animation: none;
        }

        .button:focus {
            outline: none;
            border: 2px solid var(--accent-color);
        }

        .button:active {
            transform: scale(0.95);
        }

        .sidebar.collapsed .button span {
            display: none;
        }

        .header {
            position: sticky;
            top: 0;
            height: 70px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            background: var(--glass-bg);
            backdrop-filter: blur(10px);
            padding: 0 20px;
            box-shadow: var(--shadow);
            z-index: 10;
        }

        .header .button {
            width: auto;
            padding: 12px 24px;
            margin: 0 10px;
        }

        .search-bar {
            padding: 12px;
            border-radius: 12px;
            border: var(--glass-border);
            background: var(--glass-bg);
            color: var(--text-color);
            width: 200px;
            font-size: 14px;
            tabindex: 0;
        }

        .theme-selector {
            padding: 12px;
            border-radius: 12px;
            border: var(--glass-border);
            background: var(--glass-bg);
            color: var(--text-color);
            cursor: pointer;
            font-size: 14px;
            tabindex: 0;
        }

        .content {
            flex-grow: 1;
            display: flex;
            flex-direction: column;
            background: var(--webview-bg);
            overflow: hidden;
        }

        .webviews {
            flex-grow: 1;
            position: relative;
        }

        .webview {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: none;
            background: var(--webview-bg);
        }

        .webview.active {
            display: block;
        }

        .webview iframe {
            width: 100%;
            height: 100%;
            border: none;
            loading: lazy;
        }

        .home-page {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100%;
            background: var(--webview-bg);
        }

        .home-page img {
            max-width: 80%;
            max-height: 80%;
            object-fit: contain;
        }

        .loader {
            display: none;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            border: 4px solid var(--accent-color);
            border-top: 4px solid transparent;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: translate(-50%, -50%) rotate(0deg); }
            100% { transform: translate(-50%, -50%) rotate(360deg); }
        }

        @media (max-width: 768px) {
            .sidebar {
                width: 60px;
            }

            .sidebar.collapsed {
                width: 0;
                padding: 0;
            }

            .hamburger {
                display: block;
            }

            .sidebar.collapsed .button, .sidebar.collapsed .logo {
                display: none;
            }

            .header {
                flex-wrap: wrap;
                height: auto;
                padding: 10px;
            }

            .search-bar, .theme-selector {
                width: 100%;
                margin: 10px 0;
            }

            .header .button {
                padding: 10px 16px;
                font-size: 13px;
            }

            .button {
                padding: 12px;
                font-size: 14px;
            }
        }

        @media (max-width: 768px) and (hover: none) {
            .button:hover {
                transform: scale(1);
                box-shadow: var(--glow);
                animation: pulse 3s infinite ease-in-out;
            }

            .button:active {
                transform: scale(0.95);
                box-shadow: 0 0 30px rgba(0, 221, 235, 1);
            }
        }
    </style>
</head>
<body>
    <?php
    include(__DIR__ . '/../includes/functions.php');
    global $db;
    $res = $db->select('leaguestable', '*', '', '');
    $mes = $db->select('exsport', '*', 'id = :id', '', [':id' => 1]);

    $extra_name = $mes[0]['name'] ?? '';
    $extra_link = $mes[0]['link'] ?? '';

    if (!empty($res)) {
        echo '<div class="sidebar">';
        echo '<button class="hamburger" onclick="toggleSidebar()">☰</button>';
        echo '<img class="logo" src="logo_sport.png" alt="Logo">';
        foreach ($res as $index => $row) {
            $league = htmlspecialchars($row['league']);
            $leagueId = htmlspecialchars($row['leagueId']);
            echo '<div class="button-container">';
            echo '<button class="button" onclick="loadContent(\'mainWebview\', \'sport_l_table_single.php?id=' . $leagueId . '&name=' . $league . '\')">';
            echo '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/></svg>';
            echo '<span>' . $league . '</span>';
            echo '</button>';
            echo '</div>';
        }
        echo '</div>';
    }

    $db->close();
    ?>

    <div class="content">
        <div class="header">
            <input type="text" class="search-bar" placeholder="Search Leagues...">
            <button class="button" onclick="loadContent('mainWebview','pl_buttons.php')">Leagues Slider</button>
            <button class="button" onclick="loadContent('mainWebview','leagues.php')">All Leagues</button>
            <button class="button" onclick="loadContent('mainWebview','sport_top.php')">Top Live</button>
            <button class="button" onclick="loadContent('mainWebview','sport_tv_today.php')">TV Sport</button>
            <?php if (!empty($extra_link) && !empty($extra_name)): ?>
                <button class="button" onclick="loadContent('mainWebview','<?php echo $extra_link; ?>')">
                    <?php echo $extra_name; ?>
                </button>
            <?php endif; ?>
            <select class="theme-selector" onchange="changeTheme(this.value)">
                <option value="dark">Dark Theme</option>
                <option value="light">Sparkle Theme</option>
                <option value="blue">Blue Theme</option>
                <option value="neon">Neon Theme</option>
            </select>
        </div>
        <div class="webviews">
            <div class="home-page">
                <img src="https://yoururlhere/APPLOGO/apkwizard.png" alt="Splash Image">
            </div>
            <div class="webview" id="mainWebview">
                <div class="loader"></div>
                <iframe src=""></iframe>
            </div>
        </div>
    </div>

    <script>
        function loadContent(webviewId, url) {
            const homePage = document.querySelector('.home-page');
            const webviews = document.querySelectorAll('.webview');
            const targetWebview = document.getElementById(webviewId);
            const loader = targetWebview.querySelector('.loader');

            homePage.style.display = 'none';
            webviews.forEach(view => {
                view.classList.remove('active');
                view.querySelector('iframe').src = '';
            });

            loader.style.display = 'block';
            targetWebview.classList.add('active');
            const iframe = targetWebview.querySelector('iframe');
            iframe.src = url;
            iframe.onload = () => loader.style.display = 'none';
        }

        function goHome() {
            document.querySelector('.home-page').style.display = 'flex';
            document.querySelectorAll('.webview').forEach(view => {
                view.classList.remove('active');
                view.querySelector('iframe').src = '';
            });
        }

        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('collapsed');
            document.querySelector('.hamburger').focus();
        }

        function changeTheme(theme) {
            const root = document.documentElement;
            const transitions = document.querySelectorAll('.button, .sidebar, .header, .webview');

            transitions.forEach(el => el.style.transition = 'none');
            setTimeout(() => transitions.forEach(el => el.style.transition = 'all 0.3s ease'), 50);

            switch (theme) {
                case 'light':
                    root.style.setProperty('--bg-color', '#f0f4f8');
                    root.style.setProperty('--sidebar-color', 'rgba(200, 200, 200, 0.8)');
                    root.style.setProperty('--text-color', '#333');
                    root.style.setProperty('--accent-color', '#007bff');
                    root.style.setProperty('--button-bg', 'linear-gradient(45deg, #007bff, #00ddeb, #007bff)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(45deg, #3399ff, #33eeff, #3399ff)');
                    root.style.setProperty('--webview-bg', '#ffffff');
                    root.style.setProperty('--glow', '0 0 15px rgba(0, 123, 255, 0.8), 0 0 30px rgba(0, 123, 255, 0.4)');
                    break;
                case 'dark':
                    root.style.setProperty('--bg-color', '#0a0a0a');
                    root.style.setProperty('--sidebar-color', 'rgba(26, 26, 26, 0.8)');
                    root.style.setProperty('--text-color', '#ffffff');
                    root.style.setProperty('--accent-color', '#00ddeb');
                    root.style.setProperty('--button-bg', 'linear-gradient(45deg, #00ddeb, #ff00ff, #ffffff)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(45deg, #33eeff, #ff33ff, #f0f0f0)');
                    root.style.setProperty('--webview-bg', '#1a1a1a');
                    root.style.setProperty('--glow', '0 0 15px rgba(0, 221, 235, 0.8), 0 0 30px rgba(255, 0, 255, 0.4)');
                    break;
                case 'blue':
                    root.style.setProperty('--bg-color', '#001f3f');
                    root.style.setProperty('--sidebar-color', 'rgba(0, 18, 42, 0.8)');
                    root.style.setProperty('--text-color', '#a0c4ff');
                    root.style.setProperty('--accent-color', '#007bff');
                    root.style.setProperty('--button-bg', 'linear-gradient(45deg, #007bff, #00ddeb, #007bff)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(45deg, #3399ff, #33eeff, #3399ff)');
                    root.style.setProperty('--webview-bg', '#003f5f');
                    root.style.setProperty('--glow', '0 0 15px rgba(0, 123, 255, 0.8), 0 0 30px rgba(0, 123, 255, 0.4)');
                    break;
                case 'neon':
                    root.style.setProperty('--bg-color', '#1a1a1a');
                    root.style.setProperty('--sidebar-color', 'rgba(0, 0, 0, 0.8)');
                    root.style.setProperty('--text-color', '#ffffff');
                    root.style.setProperty('--accent-color', '#ff00ff');
                    root.style.setProperty('--button-bg', 'linear-gradient(45deg, #ff00ff, #00ddeb, #ffffff)');
                    root.style.setProperty('--button-hover-bg', 'linear-gradient(45deg, #ff33ff, #33eeff, #f0f0f0)');
                    root.style.setProperty('--webview-bg', '#0a0a0a');
                    root.style.setProperty('--glow', '0 0 15px rgba(255, 0, 255, 0.8), 0 0 30px rgba(0, 221, 235, 0.4)');
                    break;
            }
        }

        // Search functionality
        document.querySelector('.search-bar').addEventListener('input', (e) => {
            const query = e.target.value.toLowerCase();
            document.querySelectorAll('.button-container .button').forEach(button => {
                const text = button.textContent.toLowerCase();
                button.parentElement.style.display = text.includes(query) ? 'block' : 'none';
            });
        });

        // Keyboard and remote navigation
        document.addEventListener('keydown', (e) => {
            const content = document.querySelector('.content');
            const step = 30;
            const focusable = Array.from(document.querySelectorAll('.button, .hamburger, .search-bar, .theme-selector'));
            let currentIndex = focusable.indexOf(document.activeElement);

            switch (e.key) {
                case 'ArrowUp':
                    content.scrollBy(0, -step);
                    if (currentIndex > 0) {
                        focusable[currentIndex - 1].focus();
                    }
                    break;
                case 'ArrowDown':
                    content.scrollBy(0, step);
                    if (currentIndex < focusable.length - 1) {
                        focusable[currentIndex + 1].focus();
                    }
                    break;
                case 'ArrowLeft':
                    if (currentIndex > 0) {
                        focusable[currentIndex - 1].focus();
                    }
                    break;
                case 'ArrowRight':
                    if (currentIndex < focusable.length - 1) {
                        focusable[currentIndex + 1].focus();
                    }
                    break;
                case 'Enter':
                    if (document.activeElement.classList.contains('button')) {
                        document.activeElement.click();
                    }
                    break;
                case 'Backspace':
                case 'Escape':
                    goHome();
                    break;
                case 'PageUp':
                    content.scrollBy(0, -content.clientHeight);
                    break;
                case 'PageDown':
                    content.scrollBy(0, content.clientHeight);
                    break;
                case 'Home':
                    content.scrollTo(0, 0);
                    focusable[0].focus();
                    break;
                case 'End':
                    content.scrollTo(0, content.scrollHeight);
                    focusable[focusable.length - 1].focus();
                    break;
            }
        });

        // Touch support for mobile
        document.querySelectorAll('.button').forEach(button => {
            button.addEventListener('touchstart', () => {
                button.style.transform = 'scale(0.95)';
                button.style.boxShadow = '0 0 30px rgba(0, 221, 235, 1)';
            });
            button.addEventListener('touchend', () => {
                button.style.transform = 'scale(1)';
                button.style.boxShadow = 'var(--glow)';
            });
        });

        window.onload = () => {
            loadContent('mainWebview', 'leagues.php');
            changeTheme('dark');
            document.querySelector('.hamburger').focus();
        };
    </script>
</body>
</html>