<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Autoplaying Backdrops with English Logos</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            position: relative; /* Added to position the backdrop and logo relative to the body */
            height: 100vh;
            background-color: #222;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        #backdrop {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .logo-container {
            position: absolute;
            top: 50%; /* Adjust top position as needed */
            left: 20px; /* Adjust left position as needed */
            z-index: 1; /* Ensures logo is above the backdrop */
            padding: 10px; /* Add padding to the logo container */
            background-color: rgba(0, 0, 0, 0.5); /* Background color with transparency */
            border-radius: 5px; /* Rounded corners */
        }
        .logo {
            max-width: 600px; /* Adjust size of the logo as needed */
        }
    </style>
</head>
<body>
<?php
    $jsonData = file_get_contents('tmdbkey.json');
    $data = json_decode($jsonData, true);
    if ($data !== null) {
        $tmdbkey = $data['tmdbkey'];
        $tmdblanguage = $data['tmdlng'];
    }
?>    
    <img id="backdrop">
    <div class="logo-container">
        <img id="logo" class="logo">
    </div>

    <script>
        const apiKey = "<?php echo $tmdbkey; ?>"; // Replace with your TMDb API key
        const language =  "<?php echo $tmdblanguage; ?>";
        let currentIndex = 0;
        let movieIds = [];

        async function fetchPopularEnglishMovieIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=en`);
                if (!response.ok) {
                    throw new Error('Failed to fetch popular English movies');
                }
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
            } catch (error) {
                console.error('Error fetching popular English movies:', error);
            }
        }

        async function fetchMovieBackdrop(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/images?api_key=${apiKey}`);
                if (!response.ok) {
                    throw new Error('Failed to fetch movie backdrops');
                }
                const data = await response.json();
                const backdropPath = data.backdrops[0].file_path; // Assuming the first backdrop in the array
                return `https://image.tmdb.org/t/p/original${backdropPath}`;
            } catch (error) {
                console.error('Error fetching movie backdrop:', error);
            }
        }

        async function fetchMovieLogo(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&append_to_response=images`);
                if (!response.ok) {
                    throw new Error('Failed to fetch movie logo');
                }
                const data = await response.json();
                const logos = data.images.logos;
                const englishLogo = logos.find(logo => logo.iso_639_1 === {language});
                if (englishLogo) {
                    return `https://image.tmdb.org/t/p/w500${englishLogo.file_path}`;
                } else {
                    return null;
                }
            } catch (error) {
                console.error('Error fetching movie logo:', error);
            }
        }

        async function updateBackdropAndLogo() {
            if (movieIds.length === 0) {
                console.error('No movie IDs available.');
                return;
            }

            const movieId = movieIds[currentIndex];

            try {
                const backdropUrl = await fetchMovieBackdrop(movieId);
                if (backdropUrl) {
                    const backdrop = document.getElementById('backdrop');
                    backdrop.src = backdropUrl;
                }

                const logoUrl = await fetchMovieLogo(movieId);
                if (logoUrl) {
                    const logo = document.getElementById('logo');
                    logo.src = logoUrl;
                }

                currentIndex = (currentIndex + 1) % movieIds.length;
            } catch (error) {
                console.error('Error updating backdrop and logo:', error);
            }
        }

        fetchPopularEnglishMovieIds().then(() => {
            setInterval(updateBackdropAndLogo, 6000); // Change backdrop and logo every 6 seconds (adjust as needed)
            updateBackdropAndLogo(); // Initial update
        });
    </script>
</body>
</html>
