<?php
header('Content-Type: text/html; charset=UTF-8');
$name = $_GET['name'] ?? 'RTX Rebrand';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RTX Rebrand Animated Text</title>
    <style>
        @property --k {
            syntax: '<number>';
            initial-value: 0;
            inherits: false;
        }

        html, body {
            display: grid;
        }

        html {
            height: 100%;
        }

        body {
            background: #000;
        }

        svg[height='0'] {
            position: absolute;
        }

        h1 {
            --k: 0;
            place-self: center;
            background: linear-gradient(90deg, 
                    hsl(calc(var(--k)*1turn), 95%, 65%), 
                    hsl(calc(var(--k)*1turn + 90deg), 95%, 65%)) text;
            color: transparent;
            font: 900 clamp(.875em, 7.25vw, 5em) sans-serif;
            filter: url(#f);
            text-align: center;
            text-transform: uppercase;
            animation: k 4s linear infinite;
        }

        @keyframes k {
            to {
                --k: 1;
            }
        }
    </style>
</head>
<body>
    <svg width="0" height="0">
        <filter id="f" x="-50%" y="-200%" width="200%" height="500%" primitiveUnits="objectBoundingBox">
            <feGaussianBlur stdDeviation=".025 .2"/>
            <feColorMatrix type="saturate" values="1.3"/>
            <feBlend in="SourceGraphic"/>
        </filter>
    </svg>
    <h1><?php echo htmlspecialchars($name); ?></h1>
</body>
</html>